/*
  ==============================================================================

    Patcher.h
    Created: 10 Aug 2013 9:33:32am
    Author:  Niall

  ==============================================================================
*/

#ifndef __PATCHER_H_9EDCF774__
#define __PATCHER_H_9EDCF774__

#include "../JuceLibraryCode/JuceHeader.h"

class MainContentComponent;
class ListenPortComponent;
class SendPortComponent;

//==============================================================================
/*
*/
class Patcher : public Component,
				public ChangeListener
{
public:
	///	Constructor.
    Patcher(MainContentComponent& mainComp);
	///	Destructor.
    ~Patcher();

	///	Draws the background.
    void paint(Graphics&);
	///	Resizes/rearranges stuff.
    void resized();

	///	Called when the user changes one of the port's settings.
	void changeListenerCallback(ChangeBroadcaster *source);

	///	Adds a listen port component.
	void addListenPort(const String& game, const String& port);
	///	Adds a send port component.
	void addSendPort(const String& game, const String& address, const String& port);

	/// Called when the user starts dragging a new connection.
	void startNewConnection(ListenPortComponent *comp);
	///	Called when the user drags a new connection.
	void dragNewConnection(const Point<int>& pos);
	/// Called when the user's finished dragging a new connection.
	void endNewConnection(const Point<int>& pos);

	///	Called when the user starts dragging an existing connection from a send port.
	void removeConnection(SendPortComponent *comp);
private:
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (Patcher)

    /// Helper method. Rebuilds all our connectionPaths.
    void rebuildPaths();
    /// Helper method. Builds the Path for a single connection.
    void buildPath(Path& path, const Point<int>& start, const Point<int>& end);

	///	Helper method. Removes the first connection it finds with the passed in sendPort as its destination.
	/*!
		\return The index of the listenPort the removed connection originated
		from (-1 if no connection was found).
	 */
	int removeFirstConnection(SendPortComponent *port);

	///	All our ListenPortComponents.
	OwnedArray<ListenPortComponent> listenPorts;
	///	The next automatically-generated listen port number.
	int nextListenPort;

	///	All our ListenPortComponents.
	OwnedArray<SendPortComponent> sendPorts;
	///	The next automatically-generated listen port number.
	int nextSendPort;

	/// Array holding the indices of the send ports each listen port is connected to.
    Array<Array<int> > connections;
    /// Array holding all our paths.
    Array<Array<Path> > connectionPaths;

    /// The temporary connection used while the user is dragging it.
    int tempStart;
    /// The mouse pos while the user is dragging the temporary connection.
    Point<int> tempMousePos;
    /// The temporary connection's path.
    Path tempPath;
	///	> -1 if the user is dragging from a send port, -1 otherwise.
	int draggingFromSend;

	///	Our copy of the MainContentComponent.
	MainContentComponent& mainComponent;
};


#endif  // __PATCHER_H_9EDCF774__
